(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3688,        120]*)
(*NotebookOutlinePosition[      4529,        147]*)
(*  CellTagsIndexPosition[      4485,        143]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \( (*\ 
      An\ example\ of\ cubic\ spline\ 
          \(quadrature : \n\t\t\tIntegrate\ f \((x)\)\) = 
        1/\((1 + 25\ x^2)\)\ from\  - 1\ to\ 1\ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[x_] := \ 1/\((1 + 25\ x^2)\); \n
    Integrate[f[x], \ {x, \ \(-1\), 1}]\)], "Input"],

Cell[BoxData[
    \(\(2\ ArcTan[5]\)\/5\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[%]\)], "Input"],

Cell[BoxData[
    \(0.549360306778006446`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(D[f[x], \ x]\)], "Input"],

Cell[BoxData[
    \(\(-\(\(50\ x\)\/\((1 + 25\ x\^2)\)\^2\)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(D[%, x]\)], "Input"],

Cell[BoxData[
    \(\(5000\ x\^2\)\/\((1 + 25\ x\^2)\)\^3 - 50\/\((1 + 25\ x\^2)\)\^2\)], 
  "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(g[x_] := \ 
      \(5000\ x\^2\)\/\((1 + 25\ x\^2)\)\^3 - 50\/\((1 + 25\ x\^2)\)\^2; 
    \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\ value = {}; \n
    For[n = 10, \ n <= \ 200, \ n = n + 10, \n\ta = \(-1\); \ b = 1; \ 
      h = \((b - a)\)/n; \n\t
      firstterm = 2*Sum[f[x], \ {x, a, b, h}] - f[a] - f[b]; \n\t
      secondterm = 2*Sum[g[x], \ {x, a, b, h}] - g[a] - g[b]; \n\t
      result = \((h/2)\)*firstterm - \((h^3/24)\)*secondterm; 
      AppendTo[\ value, \ result]; \n\t]\), 
    \(value // N\)}], "Input"],

Cell[BoxData[
    \({0.559510279475836647`, 0.549380413743242357`, 0.549360600725113812`, 
      0.549360388813107203`, 0.549360340366345845`, 0.54936032297956796`, 
      0.549360315524358711`, 0.549360311905396514`, 0.549360309979198646`, 
      0.549360308878396885`, 0.549360308212645875`, 0.549360307790981661`, 
      0.549360307513465251`, 0.549360307324803187`, 0.5493603071929396`, 
      0.549360307098535471`, 0.54936030702951637`, 0.549360306978114021`, 
      0.549360306939197773`, 0.549360306909298401`}\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 509},
WindowMargins->{{104, Automatic}, {Automatic, 12}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 188, 4, 43, "Input"],

Cell[CellGroupData[{
Cell[1922, 57, 107, 2, 43, "Input"],
Cell[2032, 61, 53, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2122, 67, 37, 1, 27, "Input"],
Cell[2162, 70, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2254, 76, 45, 1, 27, "Input"],
Cell[2302, 79, 75, 1, 45, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2414, 85, 40, 1, 27, "Input"],
Cell[2457, 88, 102, 2, 47, "Output"]
}, Open  ]],
Cell[2574, 93, 127, 3, 47, "Input"],

Cell[CellGroupData[{
Cell[2726, 100, 411, 8, 155, "Input"],
Cell[3140, 110, 532, 7, 56, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

